using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        (long x, long y)[] pocetak = new (long, long)[n];

        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            pocetak[i] = (long.Parse(parts[0]), long.Parse(parts[1]));
        }

        long susreti = 0;

        // Dictionary za svaku vrstu susreta
        var kolone = new Dictionary<(long, long), long>();
        var redovi = new Dictionary<(long, long), long>();
        var glavnaDijagonala = new Dictionary<(long, long), long>();
        var ogledaloDijagonala = new Dictionary<(long, long), long>();

        foreach (var (x, y) in pocetak)
        {
            // Kljucevi sa paritetom
            var keyKolona = (x, y % 2);
            var keyRed = (y, x % 2);
            var keyGlavna = (x - y, x % 2);
            var keyOgledalo = (x + y, x % 2);

            // Kolona
            if (kolone.ContainsKey(keyKolona))
                susreti += kolone[keyKolona];
            kolone[keyKolona] = kolone.GetValueOrDefault(keyKolona) + 1;

            // Red
            if (redovi.ContainsKey(keyRed))
                susreti += redovi[keyRed];
            redovi[keyRed] = redovi.GetValueOrDefault(keyRed) + 1;

            // Glavna dijagonala
            if (glavnaDijagonala.ContainsKey(keyGlavna))
                susreti += 2 * glavnaDijagonala[keyGlavna];
            glavnaDijagonala[keyGlavna] = glavnaDijagonala.GetValueOrDefault(keyGlavna) + 1;

            // Ogledalo dijagonala
            if (ogledaloDijagonala.ContainsKey(keyOgledalo))
                susreti += 2 * ogledaloDijagonala[keyOgledalo];
            ogledaloDijagonala[keyOgledalo] = ogledaloDijagonala.GetValueOrDefault(keyOgledalo) + 1;
        }

        Console.WriteLine(susreti);
    }
}